<?php
/*======================================================================*\
|| #################################################################### ||
|| # Top 'X' Stats by InfiniteWebby for 3.5.0 RC1                     # ||
|| # ---------------------------------------------------------------- # ||
|| # All PHP code in this file is 2000-2005 InfiniteWebby            # ||
|| # Email: infinitewebby@hotmail.com                                 # ||
|| #################################################################### ||
\*======================================================================*/

// ######################## SET PHP ENVIRONMENT ###########################
error_reporting(E_ALL & ~E_NOTICE);

// ##################### DEFINE IMPORTANT CONSTANTS #######################
define('NO_REGISTER_GLOBALS', 1);
define('THIS_SCRIPT', 'topXstats.php');

// #################### PRE-CACHE TEMPLATES AND DATA ######################
// get special phrase groups
$phrasegroups = array();

// get special data templates from the datastore
$specialtemplates = array();

// pre-cache templates used by all actions
$globaltemplates = array(
	'TOPXSTATS',
	'topXstats_stats_bit',
	'topXstats_member_bit',
	'topXstats_poster_bit',
	'topXstats_thread_bit'
);

// pre-cache templates used by specific actions
$actiontemplates = array();

// ########################## REQUIRE BACK-END ############################
require_once('./global.php');

// #######################################################################
// ######################## START MAIN SCRIPT ############################
// #######################################################################

// ### TOP X STATS BY INFINITEWEBBY ###########################################
global $vbulletin;

$displayrecords = $vbulletin->input->clean_gpc('r', 'displayrecords', TYPE_UINT);

if ($displayrecords <= 0) {
	$displayrecords = $vbulletin->options['topXstats_displayrecords'];
} else if ($displayrecords >= $vbulletin->options['topXstats_maxdisplayrecords']) {
	$displayrecords = $vbulletin->options['topXstats_maxdisplayrecords'];
} else {
	$displayrecords = $displayrecords;
}

if ($vbulletin->options['topXstats_excludedforums'] !== '') {
	$excludedforums = ',' . $vbulletin->options['topXstats_excludedforums'];
}

$forumpermissions = array();
foreach($vbulletin->forumcache AS $forum) {

	$forumpermissions[$forum["forumid"]] = fetch_permissions($forum['forumid']);

	// ## HIDE FORUMS WITHOUT THE CANVIEW, CANVIEWOTHERS OR CANSEEDELNOTICE PERMISSION ##
	if (!($forumpermissions[$forum["forumid"]] & $vbulletin->bf_ugp_forumpermissions['canview']) AND !$vbulletin->options['showprivateforums'])  {
		$excludedforums = $excludedforums . ',' . $forum['forumid'];
	}
	// filter out deletion notices if can't be seen
	if ($forumpermissions[$forum["forumid"]] & $vbulletin->bf_ugp_forumpermissions['canseedelnotice'] OR can_moderate($forum['forumid'])){
		$deljoin = "LEFT JOIN " . TABLE_PREFIX . "deletionlog AS deletionlog ON(thread.threadid = deletionlog.primaryid AND type = 'thread')";
	} else {
		$deljoin = '';
	}
}


unset($forum);

// get rid of initial comma
$excludedforums = substr($excludedforums, 1);

if ($excludedforums != "") {
	$excludedforums = "AND thread.forumid NOT IN ($excludedforums)";
}

$threadchars = $vbulletin->options['topXstats_threadchars'];
if ($threadchars <= 0) {
	$threadchars = $vbulletin->options['lastthreadchars'];
}

$userchars = $vbulletin->options['topXstats_userchars'];
$newpostprefix = $vbulletin->options['topXstats_newpostprefix'];
$oldpostprefix = $vbulletin->options['topXstats_oldpostprefix'];

if ($threadchars <= 0) {
	$threadchars = $vbulletin->options['lastthreadchars'];
}

$getstats_posters = $db->query_read("SELECT userid, usergroupid, IF(displaygroupid=0, usergroupid, displaygroupid) AS displaygroupid, username, posts FROM " . TABLE_PREFIX . "user ORDER BY posts DESC LIMIT 0, $displayrecords");
while ($getstats_poster = $db->fetch_array($getstats_posters))
{
	if ($userchars > 0) {

		if (strlen($getstats_poster[username]) > $userchars)
		{		
			$getstats_poster[username] = substr($getstats_poster[username], 0, $userchars) . '...';
		}
		else
		{
			$getstats_poster[username] = $getstats_poster[username];
		}
	}
	$getstats_poster[musername] = fetch_musername($getstats_poster);
	eval('$topXstats_posters_bits .= "' . fetch_template('topXstats_poster_bit') . '";');
}

$getstats_members = $db->query_read("SELECT userid, usergroupid, IF(displaygroupid=0, usergroupid, displaygroupid) AS displaygroupid, username, posts, joindate FROM " . TABLE_PREFIX . "user ORDER BY joindate DESC LIMIT 0, $displayrecords");
while ($getstats_member = $db->fetch_array($getstats_members))
{
	if ($userchars > 0) {
		if (strlen($getstats_member[username]) > $userchars)
		{		
			$getstats_member[username] = substr($getstats_member[username], 0, $userchars) . '...';
		}
		else
		{
			$getstats_member[username] = $getstats_member[username];
		}
	}
	$getstats_member[musername] = fetch_musername($getstats_member);
	eval('$topXstats_members_bits .= "' . fetch_template('topXstats_member_bit') . '";');
}

$getstats_threads = $db->query_read("
	SELECT
		thread.threadid, thread.title, thread.lastpost, thread.forumid, thread.replycount, thread.lastposter, thread.dateline, IF(views<=replycount, replycount+1, views) AS views, thread.visible, user.username, user.userid, user.usergroupid, IF(displaygroupid=0, user.usergroupid, displaygroupid) AS displaygroupid
		" . iif($deljoin, ", NOT ISNULL(deletionlog.primaryid) AS isdeleted, deletionlog.userid AS del_userid, deletionlog.username AS del_username, deletionlog.reason AS del_reason") . "
	FROM " . TABLE_PREFIX . "thread AS thread
		LEFT JOIN  " . TABLE_PREFIX . "user AS user ON (user.username = thread.lastposter)
		$deljoin
		WHERE NOT ISNULL(thread.threadid)
		$excludedforums
		" . iif(!$deljoin, "AND thread.visible <> 2") . "
	ORDER BY lastpost DESC LIMIT 0, $displayrecords");

while ($getstats_thread = $db->fetch_array($getstats_threads))
{
	$getstats_thread[title] = unhtmlspecialchars($getstats_thread[title]);
	if ($threadchars > 0) {
		if (strlen($getstats_thread[title]) > $threadchars)
		{		
			$getstats_thread[titletrimmed] = substr($getstats_thread[title], 0, strrpos(substr($getstats_thread[title], 0, $threadchars), ' ')) . '...';
		}
		else
		{
			$getstats_thread[titletrimmed] = $getstats_thread[title];
		}
	}
	if ($getstats_thread[lastpost] > $vbulletin->userinfo['lastvisit'])
	{
		$getstats_thread[newpost] = true;
	}
	if ($getstats_thread[isdeleted])
	{
		$getstats_thread[isdeleted] = true;
	}
	if ($userchars > 0) {
		if (strlen($getstats_thread[username]) > $userchars)
		{		
			$getstats_thread[username] = substr($getstats_thread[username], 0, $userchars) . '...';
		}
		else
		{
			$getstats_thread[username] = $getstats_thread[username];
		}
	}
	$getstats_member[musername] = fetch_musername($getstats_thread);
	eval('$topXstats_threads_bits .= "' . fetch_template('topXstats_thread_bit') . '";');
}

eval('$topXstats .= "' . fetch_template('topXstats_stats_bit') . '";');

$navbits = construct_navbits(array('' => $vbphrase[statistics]));
eval('$navbar = "' . fetch_template('navbar') . '";');

construct_forum_jump();

eval('print_output("' . fetch_template('TOPXSTATS') . '");');

/*======================================================================*\
|| #################################################################### ||
|| #           This is the greatest footer ever! Hoorah!              # ||
|| #################################################################### ||
\*======================================================================*/
?>